clc
clear 
close all

name = {'elev', 'srad', 'tavg', 'tmax', 'tmin', 'vapr', 'wind'}; % print the name of the folder
folder = cellfun(@(p) addpath(strrep("wc2.1_30s_%PARAM%", "%PARAM%", p)), name, 'UniformOutput', false);

months = sprintfc('%02d', 12); % print the # of months

c = 43200/2;

% elevation
[elev, ref] = readgeoraster("wc2.1_30s_elev\wc2.1_30s_elev.tif");
elev = single(elev);
elev(elev == (min(elev, [], "all"))) = NaN;

disp("Elevation")

% solar radiation
srad = readgeoraster(strrep("wc2.1_30s_srad\wc2.1_30s_srad_%m%.tif", "%m%", months));
srad = single(srad);
srad = srad .* 10^(-3); % from kJ/(m^2*d) to MJ/(m^2*d);

disp("Solar radiation")

% maximum temperature
Tmax = readgeoraster(strrep("wc2.1_30s_tmax\wc2.1_30s_tmax_%m%.tif", "%m%", months));
Tmax(Tmax == (min(Tmax, [], "all"))) = NaN;

disp("Maximium temperature")

% minimum temperature
Tmin = readgeoraster(strrep("wc2.1_30s_tmin\wc2.1_30s_tmin_%m%.tif", "%m%", months));
Tmin(Tmin == (min(Tmin, [], "all"))) = NaN;

disp("Minimum temperature")

% water vapour pressure
vapr = readgeoraster(strrep("wc2.1_30s_vapr\wc2.1_30s_vapr_%m%.tif", "%m%", months));
vapr(vapr == (min(vapr, [], "all"))) = NaN;

disp("Water vapour pressure")


%% net solar radiation
sigma = 4.90*10^(-9); % Stefan-Boltzmann constant, measured in [MJ/(m^2*K^4*d)]
albedo = 0.38; % mean albedo of the earth

% Group 1:
% Tmax = Tmax(:, 1:c) + 273.15; % in K
% Tmin = Tmin(:, 1:c) + 273.15; % in K
% elev = elev(:, 1:c);
% vapr = vapr(:, 1:c);
% srad = srad(:, 1:c);

% Group 2:
Tmax = Tmax(:, c+1:end) + 273.15; % in K
Tmin = Tmin(:, c+1:end) + 273.15; % in K
elev = elev(:, c+1:end);
vapr = vapr(:, c+1:end);
srad = srad(:, c+1:end);

Ra = srad ./ (0.18 .* sqrt(Tmax-Tmin));
disp("Ra")
Rso = (0.75 + 0.00002 .* elev).* Ra;
disp("Rso")


Rnl = 0.5*sigma*(Tmax.^4 + Tmin.^4) .* (0.34 - 0.14 .* sqrt(vapr)) .* (1.35*(srad ./ Rso) - 0.35);
disp("Rnl")


Rn = (1 - albedo) .* srad - Rnl;
Rn(Rn < 0) = 0;
disp("Rn")

disp("Saving Rn...")

save(strrep("Rn2_%m%.mat", "%m%", months), "Rn", "-v7.3");

%% Putting together the net solar radiations

Rn1 = load(strrep("Rn1_%m%.mat", "%m%", months));
Rn2 = load(strrep("Rn2_%m%.mat", "%m%", months));

Rn1 = Rn1.Rn;
Rn2 = Rn2.Rn;
Rn_tog = [Rn1 Rn2];

disp("Saving Rn together...")

save(strrep("Rn_%m%.mat", "%m%", months), "Rn_tog", "-v7.3");